<?php

/**
 * Customizer Header Settings
 *
 * style for theme headers
 */

// header settings
$fields[] = [
  'type'     => 'custom',
  'settings' => 'header_setting_custom_01',
  'label'    => FALSE,
  'section'  => 'header_settings',
  'default'  => '<div class="customizer_label mt-25">' . esc_html__('Header Settings', 'bexon') . '</div>',
  'description' => '<div class="alert alert-danger" role="alert">' . esc_html__('These options are only for the theme default header which is not built with Elementor. Navigate to Dashboard -> Theme Builder to customize the header', 'bexon') . '</div>',
];
// header sticky
$fields[] = [
  'type'            => 'toggle',
  'settings'        => 'header_sticky',
  'label'           => esc_html__('Is header sticky?', 'bexon'),
  'section'         => 'header_settings',
  'default'         => false,
];
$fields[] = [
  'type'            => 'select',
  'settings'        => 'sticky_direction',
  'label'           => esc_html__('Sticky Direction', 'bexon'),
  'section'         => 'header_settings',
  'default'         => '',
  'choices'         => [
    ''            => esc_html__('Default', 'bexon'),
    'sticky-up'   => esc_html__('Scroll Up', 'bexon'),
    'sticky-down' => esc_html__('Scroll Down', 'bexon'),
  ],
  'active_callback' => [
    [
      'setting'  => 'header_sticky',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// header absolute
$fields[] = [
  'type'            => 'toggle',
  'settings'        => 'header_absolute',
  'label'           => esc_html__('Is header transparent?', 'bexon'),
  'section'         => 'header_settings',
  'default'         => false,
];
// header button
$fields[] = [
  'type'            => 'toggle',
  'settings'        => 'show_header_button',
  'label'           => esc_html__('Show header button?', 'bexon'),
  'section'         => 'header_settings',
  'default'         => false,
];
// button text
$fields[] = [
  'type'     => 'text',
  'settings' => 'header_btn_text',
  'label'    => esc_html__('Button Text', 'bexon'),
  'section'  => 'header_settings',
  'default'  => esc_html__('Let’s Talk', 'bexon'),
  'active_callback' => [
    [
      'setting'  => 'show_header_button',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// button link
$fields[] = [
  'type'     => 'text',
  'settings' => 'header_btn_link',
  'label'    => esc_html__('Button Link', 'bexon'),
  'section'  => 'header_settings',
  'default'  => esc_attr("#"),
  'active_callback' => [
    [
      'setting'  => 'show_header_button',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
