<?php

/**
 * Customizer Page Header Settings
 *
 * style for theme page header style
 */

$fields[] = [
  'type'     => 'custom',
  'settings' => 'header_custom_01',
  'label'    => FALSE,
  'section'  => 'pageheader_setting',
  'default'  => '<div class="customizer_label">' . esc_html__('Page Header Settings', 'bexon') . '</div>',
];
// page header info
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'show_page_header',
  'label'    => esc_html__('Show page header?', 'bexon'),
  'section'  => 'pageheader_setting',
  'default'  => '1',
];
// background image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'page_header_bg_img',
  'label'       => esc_html__('Background Image', 'bexon'),
  'section'     => 'pageheader_setting',
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
$fields[] = [
  'type'        => 'image',
  'settings'    => 'overlay_bg_img',
  'label'       => esc_html__('Overlay Image', 'bexon'),
  'section'     => 'pageheader_setting',
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// background color
$fields[] = [
  'type'        => 'color',
  'settings'    => 'page_header_bg_color',
  'label'       => __('Background Color', 'bexon'),
  'section'     => 'pageheader_setting',
  'output'      => [
    [
      'element'  => '.tj-page-header',
      'property' => 'background-color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

// page header nav
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'show_page_header_nav',
  'label'    => esc_html__('Page Header Nav on/off?', 'bexon'),
  'section'  => 'pageheader_setting',
  'default'  => false,
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// Parent title
$fields[] = [
  'type'            => 'text',
  'settings'        => 'pagenav_parent_title',
  'label'           => esc_html__('Parent Title', 'bexon'),
  'section'         => 'pageheader_setting',
  'default'         => esc_html__('Home', 'bexon'),
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
    [
      'setting'  => 'show_page_header_nav',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'        => 'color',
  'settings'    => 'page_title_color',
  'label'       => __('Title Color', 'bexon'),
  'section'     => 'pageheader_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-title',
      'property' => 'color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ]
  ],
];

$fields[] = [
  'type'        => 'color',
  'settings'    => 'page_nav_bg_color',
  'label'       => __('Nav Bg Color', 'bexon'),
  'section'     => 'pageheader_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-navs',
      'property' => 'background',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
    [
      'setting'  => 'show_page_header_nav',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'        => 'color',
  'settings'    => 'page_nav_color',
  'label'       => __('Nav Color', 'bexon'),
  'section'     => 'pageheader_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-navs, .tj-page-navs span',
      'property' => 'color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
    [
      'setting'  => 'show_page_header_nav',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
$fields[] = [
  'type'        => 'color',
  'settings'    => 'page_nav_link_color',
  'label'       => __('Nav link Color', 'bexon'),
  'section'     => 'pageheader_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-navs a span, .tj-page-navs span a',
      'property' => 'color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
    [
      'setting'  => 'show_page_header_nav',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
$fields[] = [
  'type'        => 'color',
  'settings'    => 'page_nav_link_hv_color',
  'label'       => __('Nav link Hover Color', 'bexon'),
  'section'     => 'pageheader_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-navs a:hover span, .tj-page-navs span a:hover',
      'property' => 'color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
    [
      'setting'  => 'show_page_header_nav',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
$fields[] = [
  'type'        => 'color',
  'settings'    => 'page_nav_icon_color',
  'label'       => __('Nav Icon Color', 'bexon'),
  'section'     => 'pageheader_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'output'      => [
    [
      'element'  => '.tj-page-navs span i',
      'property' => 'color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_page_header',
      'operator' => '==',
      'value'    => '1',
    ],
    [
      'setting'  => 'show_page_header_nav',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

$fields[] = [
  'type'     => 'dimensions',
  'settings' => 'breadcrumb_padding',
  'section'  => 'pageheader_setting',
  'transport'   => 'auto',
  'responsive' => true,
  'default'     => [
    'desktop' => [
      'padding-top'  => '',
      'padding-bottom' => '',
    ],
    'tablet'  => [
      'padding-top'  => '',
      'padding-bottom' => '',
    ],
    'mobile'  => [
      'padding-top'  => '',
      'padding-bottom' => '',
    ],
  ],
  'choices'     => [
    'labels' => [
      'padding-top'  => esc_html__('Padding Top', 'bexon'),
      'padding-bottom' => esc_html__('Padding Bottom', 'bexon'),
    ],
  ],
  'output'      => [
    [
      'choice'   => 'padding-top',
      'element'  => '.tj-page-header',
      'property' => 'padding-top',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'   => 'padding-bottom',
      'element'  => '.tj-page-header',
      'property' => 'padding-bottom',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
  ],
];
$fields[] = [
  'type'        => 'dimensions',
  'settings'    => 'page_header_margin',
  'label'       => esc_html__('Margin', 'bexon'),
  'section'     => 'pageheader_setting',
  'transport'   => 'auto',
  'responsive'  => true,
  'default'     => [
    'desktop' => [
      'top'    => '',
      'right'  => '',
      'bottom' => '',
      'left'   => '',
    ],
    'tablet' => [
      'top'    => '',
      'right'  => '',
      'bottom' => '',
      'left'   => '',
    ],
    'mobile' => [
      'top'    => '',
      'right'  => '',
      'bottom' => '',
      'left'   => '',
    ],
  ],
  'choices' => [
    'labels' => [
      'top'    => esc_html__('Top', 'bexon'),
      'right'  => esc_html__('Right', 'bexon'),
      'bottom' => esc_html__('Bottom', 'bexon'),
      'left'   => esc_html__('Left', 'bexon'),
    ],
  ],
  'output' => [
    [
      'choice'      => 'top',
      'element'     => '.tj-page-header',
      'property'    => 'margin-top',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'      => 'right',
      'element'     => '.tj-page-header',
      'property'    => 'margin-right',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'      => 'bottom',
      'element'     => '.tj-page-header',
      'property'    => 'margin-bottom',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'      => 'left',
      'element'     => '.tj-page-header',
      'property'    => 'margin-left',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
  ],
];

$fields[] = [
  'type'       => 'dimensions',
  'settings'   => 'page_header_border_radius',
  'label'      => esc_html__('Border Radius', 'bexon'),
  'section'    => 'pageheader_setting',
  'transport'  => 'auto',
  'responsive' => true,
  'default'    => [
    'desktop' => [
      'top'    => '',
      'right'  => '',
      'bottom' => '',
      'left'   => '',
    ],
    'tablet' => [
      'top'    => '',
      'right'  => '',
      'bottom' => '',
      'left'   => '',
    ],
    'mobile' => [
      'top'    => '',
      'right'  => '',
      'bottom' => '',
      'left'   => '',
    ],
  ],
  'choices' => [
    'labels' => [
      'top'    => esc_html__('Top Left', 'bexon'),
      'right'  => esc_html__('Top Right', 'bexon'),
      'bottom' => esc_html__('Bottom Right', 'bexon'),
      'left'   => esc_html__('Bottom Left', 'bexon'),
    ],
  ],
  'output' => [
    [
      'choice'      => 'top',
      'element'     => '.tj-page-header',
      'property'    => 'border-top-left-radius',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'      => 'right',
      'element'     => '.tj-page-header',
      'property'    => 'border-top-right-radius',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'      => 'bottom',
      'element'     => '.tj-page-header',
      'property'    => 'border-bottom-right-radius',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
    [
      'choice'      => 'left',
      'element'     => '.tj-page-header',
      'property'    => 'border-bottom-left-radius',
      'media_query' => [
        'desktop' => '@media (min-width: 992px)',
        'tablet'  => '@media (min-width: 768px) and (max-width: 991px)',
        'mobile'  => '@media (max-width: 767px)',
      ],
    ],
  ],
];
