<?php

/**
 * WooCommerce Compatibility File
 *
 * @link https://woocommerce.com/
 *
 * @package Solvior_Theme
 */

/**
 * WooCommerce setup function.
 *
 * @link https://docs.woocommerce.com/document/third-party-custom-theme-compatibility/
 * @link https://github.com/woocommerce/woocommerce/wiki/Enabling-product-gallery-features-(zoom,-swipe,-lightbox)-in-3.0.0
 *
 * @return void
 */
function tj_woocommerce_setup()
{
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-zoom');
    add_theme_support('wc-product-gallery-slider');
    add_theme_support('wc-product-gallery-lightbox');
    // Remove woocommerce defauly styles
    add_filter('woocommerce_enqueue_styles', '__return_false');
}
add_action('after_setup_theme', 'tj_woocommerce_setup');

/**
 * Register widget area for shop page.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function tj_woocommerce_widgets_init()
{
    register_sidebar(array(
        'name'          => __('Shop Sidebar', 'bexon'),
        'id'            => 'shop-sidebar',
        'before_widget' => '<div id="%1$s" class="product-widget %2$s">',
        'after_widget' => '</div>',
        'before_title'  => '<h5 class="product-widget-title">',
        'after_title'   => '</h5>',
    ));
}
add_action('widgets_init', 'tj_woocommerce_widgets_init');

/**
 * Add 'woocommerce-active' class to the body tag.
 *
 * @param  array $classes CSS classes applied to the body tag.
 * @return array $classes modified to include 'woocommerce-active' class.
 */
function tj_woocommerce_active_body_class($classes)
{
    $classes[] = 'woocommerce-active';

    return $classes;
}
add_filter('body_class', 'tj_woocommerce_active_body_class');


// shop page hooks
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);

//single hook remove
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);


// compare_false
add_filter('woosc_button_position_archive', '__return_false');
add_filter('woosc_button_position_single', '__return_false');

// wishlist false
add_filter('woosw_button_position_archive', '__return_false');
add_filter('woosw_button_position_single', '__return_false');


// product-content single
if (!function_exists('tj_content_single_details')) {
    function tj_content_single_details()
    {
        global $product;
        $rating = wc_get_rating_html($product->get_average_rating());
        $ratingcount = $product->get_review_count();
        $stock = $product->is_in_stock();
        $post_url = get_the_permalink();
        $product_stock = get_theme_mod('product_stock', false);
        $product_meta = get_theme_mod('product_meta', true);
        $product_share = get_theme_mod('product_share', true);
?>

        <div class="tj-product-details-wrapper">
            <h3 class="tj-product-details-title"><?php the_title(); ?></h3>
            <!-- price -->
            <div class="tj-product-details-price-wrapper">
                <?php woocommerce_template_single_price(); ?>
            </div>
            <!-- inventory details -->
            <div class="tj-product-details-inventory">
                <?php if (!empty($product_stock)) : ?>
                    <?php if ($stock) : ?>
                        <div class="tj-product-details-stock">
                            <span class="in-stock"><?php echo esc_html__('In stock', 'bexon'); ?></span>
                        </div>
                    <?php else : ?>
                        <div class="tj-product-details-stock">
                            <span class="out-stock"><?php echo esc_html__('Out of stock', 'bexon'); ?></span>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (!empty($rating)) : ?>
                    <div class="tj-product-details-rating d-flex align-items-center">
                        <?php echo wp_kses_post($rating); ?>
                        <div class="tj-product-details-reviews">
                            <span>( <?php echo esc_html($ratingcount); ?> <?php echo esc_html__('customer ', 'bexon');
                                                                            echo esc_html($ratingcount) <= 1 ? 'review' : 'reviews'; ?> )</span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <?php if (!empty(woocommerce_template_single_excerpt())) : ?>
                <p><?php woocommerce_template_single_excerpt(); ?></p>
            <?php endif; ?>

            <!-- actions -->
            <div class="tj-product-details-action-wrapper">
                <?php woocommerce_template_single_add_to_cart(); ?>
                <!-- buy now button -->
                <?php if ($stock) : ?>
                    <?php echo buy_now_button(); ?>
                <?php endif; ?>
            </div>
            <?php if (!empty($product_meta)) : ?>
                <div class="tj-product-details-query">
                    <h6 class="tj-product-details-query-title"><?php echo esc_html__('Product Info', 'bexon'); ?></h6>
                    <?php woocommerce_template_single_meta(); ?>
                </div>
            <?php endif; ?>
            <?php if (!empty($product_share)) : ?>
                <div class="tj-product-details-share">
                    <h6><?php echo esc_html__('Share:', 'bexon'); ?></h6>
                    <a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($post_url); ?>"><i class="fa-brands fa-facebook-f"></i></a>

                    <a target="_blank" href="https://twitter.com/intent/tweet?url=<?php echo esc_url($post_url); ?>"><i class="fab fa-x-twitter"></i></a>

                    <a target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo esc_url($post_url); ?>"><i class="fa-brands fa-linkedin-in"></i></a>

                    <a target="blank" href="https://pinterest.com/pin/create/button/?url=<?php echo esc_url($post_url); ?>&media=<?php the_post_thumbnail_url('full'); ?>">
                        <i class="fa-brands fa-pinterest-p"></i>
                    </a>
                    <a target="_blank" href="https://www.youtube.com/shareArticle?mini=true&url=<?php echo esc_url($post_url); ?>"><i class="fa-brands fa-youtube"></i></a>
                </div>
            <?php endif; ?>
        </div>

    <?php
    }
}
add_action('woocommerce_single_product_summary', 'tj_content_single_details', 4);


/*************************************************
## sale percentage
 *************************************************/

function tj_sale_percentage()
{
    global $product;
    $output = '';

    if ($product->is_on_sale() && $product->is_type('variable')) {
        $percentage = ceil(100 - ($product->get_variation_sale_price() / $product->get_variation_regular_price('min')) * 100);
        $output .= '<span class="product__details-offer">-' . $percentage . '%</span>';
    } elseif ($product->is_on_sale() && $product->get_regular_price()  && !$product->is_type('grouped')) {
        $percentage = ceil(100 - ($product->get_sale_price() / $product->get_regular_price()) * 100);
        $output .= '<span class="product__details-offer">-' . $percentage . '%</span>';
    }
    return $output;
}


// woocommerce mini cart content
add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start();
    ?>
    <div class="mini_shopping_cart_box">
        <?php woocommerce_mini_cart(); ?>
    </div>
    <?php $fragments['.mini_shopping_cart_box'] = ob_get_clean();
    return $fragments;
});

// woocommerce mini cart count icon
if (!function_exists('tj_header_add_to_cart_fragment')) {
    function tj_header_add_to_cart_fragment($fragments)
    {
        ob_start();
    ?>
        <span class="cart__count cart-item">
            <?php echo esc_html(WC()->cart->cart_contents_count); ?>
        </span>
    <?php
        $fragments['.cart-item'] = ob_get_clean();

        return $fragments;
    }
}
add_filter('woocommerce_add_to_cart_fragments', 'tj_header_add_to_cart_fragment');

// product-content archive
if (!function_exists('tj_content_product_grid')) {
    function tj_content_product_grid()
    {
        global $product;
        global $post;
        global $woocommerce;
        $rating = wc_get_rating_html($product->get_average_rating());
        $stock = $product->is_in_stock();
        $terms = get_the_terms(get_the_ID(), 'product_cat');
        $attachment_ids = $product->get_gallery_image_ids();

        foreach ($attachment_ids as $key => $attachment_id) {
            $image_link =  wp_get_attachment_url($attachment_id);
            $arr[] = $image_link;
        }
    ?>
        <div class="tj-product-item">
            <?php if (has_post_thumbnail()) : ?>
                <div class="tj-product-thumb">
                    <a href="<?php the_permalink(); ?>">
                        <?php the_post_thumbnail(); ?>
                    </a>

                    <?php if ($product->is_on_sale()) : ?>
                        <div class="tj-product-badge product-on-sale">
                            <?php woocommerce_show_product_loop_sale_flash($post->ID); ?>
                        </div>
                    <?php endif; ?>

                    <!-- product action -->
                    <div class="tj-product-action">
                        <div class="tj-product-action-item d-flex flex-column">
                            <?php if (function_exists('woosw_init')) : ?>
                                <div class="tj-product-action-btn product-add-wishlist-btn">
                                    <?php echo do_shortcode('[woosw]'); ?>
                                    <span class="tj-product-action-btn-tooltip"><?php echo esc_html__('Add to wishlist', 'bexon'); ?></span>
                                </div>
                            <?php endif; ?>

                            <?php if (class_exists('WPCleverWoosq')) : ?>
                                <div class="tj-product-action-btn">
                                    <?php echo do_shortcode('[woosq]'); ?>
                                    <span class="tj-product-action-btn-tooltip"><?php echo esc_html__('Quick view', 'bexon'); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if ($stock) : ?>
                        <div class="tj-product-cart-btn">
                            <?php woocommerce_template_loop_add_to_cart(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="tj-product-content">
                <div class="tj-product-tag d-none">
                    <?php foreach ($terms as $key => $term) :
                        $count = count($terms) - 1;
                        $name = ($count > $key) ? $term->name . ', ' : $term->name;
                    ?>
                        <a href="<?php echo get_term_link($term->slug, 'product_cat'); ?> "> <?php echo esc_html($name); ?></a>
                    <?php endforeach; ?>
                </div>
                <h3 class="tj-product-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h3>

                <div class="tj-product-price-wrapper">
                    <?php echo woocommerce_template_loop_price(); ?>
                </div>

                <?php if (!empty($rating)) : ?>
                    <div class="tj-product-rating">
                        <?php echo wp_kses_post($rating); ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php
    }
}
add_action('woocommerce_before_shop_loop_item', 'tj_content_product_grid', 10);


// smart quickview
add_filter('woosq_button_html', 'tj_woosq_button_html', 10, 2);
function tj_woosq_button_html($output, $prodid)
{
    return $output = '<a href="#" class="woosq-btn woosq-btn-' . esc_attr($prodid) . ' ' . get_option('woosq_button_class') . '" data-id="' . esc_attr($prodid) . '" data-effect="mfp-3d-unfold"><i class="fal fa-eye"></i></a>';
}

// product add to cart button
function woocommerce_template_loop_add_to_cart($args = array())
{
    global $product;

    $stock = $product->is_in_stock();

    $stock_class = $stock ? 'stock-available' : 'stock-out';

    $price = $product->get_regular_price();

    $price_class = $price ? NULL : 'price-empty';

    if ($product) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        'cart-button button tj-cart-btn ' . $stock_class . ' ' . $price_class,
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = wp_parse_args($args, $defaults);

        if (isset($args['attributes']['aria-label'])) {
            $args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
        }
    }

    // check product type 
    if ($product->is_type('simple')) {
        $btntext = esc_html__("Add to cart", 'bexon');
    } elseif ($product->is_type('variable')) {
        $btntext = esc_html__("Select Options", 'bexon');
    } elseif ($product->is_type('external')) {
        $btntext = esc_html__("Buy now", 'bexon');
    } elseif ($product->is_type('grouped')) {
        $btntext = esc_html__("View products", 'bexon');
    } else {
        $btntext = "Add to cart";
    }

    echo sprintf(
        '<a href="%s" data-quantity="%s" class="%s product-add-cart-btn" %s>%s</a>',
        esc_url($product->add_to_cart_url()),
        esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
        esc_attr(isset($args['class']) ? $args['class'] : 'cart-button button tj-cart-btn ' . $stock_class),
        isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
        '<span class="btn-icon"><i class="fal fa-shopping-cart"></i><i class="fal fa-shopping-cart"></i></span><span class="btn-text"><span>' . $btntext . '</span></span>'
    );
}

function buy_now_button()
{
    global $product;
    $buy_now_text = __('Shop now', 'bexon');
    $checkout_url = wc_get_checkout_url();

    return '<a href="' . esc_url(add_query_arg('add-to-cart', $product->get_id(), $checkout_url)) . '" class="tj-product-details-buy-now-btn w-100"><span class="btn-text"><span>' . $buy_now_text . '</span></span></a>';
}

add_action('wp_footer', 'custom_quantity_fields_script');

// custom_quantity_fields_script
function custom_quantity_fields_script()
{
    ?>
    <script type='text/javascript'>
        jQuery(function($) {
            if (!String.prototype.getDecimals) {
                String.prototype.getDecimals = function() {
                    var num = this,
                        match = ('' + num).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);
                    if (!match) {
                        return 0;
                    }
                    return Math.max(0, (match[1] ? match[1].length : 0) - (match[2] ? +match[2] : 0));
                }
            }
            // Quantity "plus" and "minus" buttons
            $(document.body).on('click', '.plus, .minus', function() {
                var $qty = $(this).closest('.quantity').find('.qty'),
                    currentVal = parseFloat($qty.val()),
                    max = parseFloat($qty.attr('max')),
                    min = parseFloat($qty.attr('min')),
                    step = $qty.attr('step');

                // Format values
                if (!currentVal || currentVal === '' || currentVal === 'NaN') currentVal = 0;
                if (max === '' || max === 'NaN') max = '';
                if (min === '' || min === 'NaN') min = 0;
                if (step === 'any' || step === '' || step === undefined || parseFloat(step) === 'NaN') step = 1;

                // Change the value
                if ($(this).is('.plus')) {
                    if (max && (currentVal >= max)) {
                        $qty.val(max);
                    } else {
                        $qty.val((currentVal + parseFloat(step)).toFixed(step.getDecimals()));
                    }
                } else {
                    if (min && (currentVal <= min)) {
                        $qty.val(min);
                    } else if (currentVal > 0) {
                        $qty.val((currentVal - parseFloat(step)).toFixed(step.getDecimals()));
                    }
                }

                // Trigger change event
                $qty.trigger('change');
            });
        });
    </script>
<?php
}
