<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

get_header();

$bexonBlogColumn = is_active_sidebar('blog-sidebar') ? 8 : 12;
?>

<div class="tj-post-area section-gap">
	<div class="container">
		<div class="row row-gap-45">
			<div class="col-lg-<?php print esc_attr($bexonBlogColumn); ?>">
				<!-- post container -->
				<div class="tj-post-container blog-post-wrapper">
					<?php if (have_posts()) :

						/* Start the Loop */
						while (have_posts()) : the_post();

							/*
							 * Include the Post-Type-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
							 */
							get_template_part('template-parts/content', get_post_format());

						endwhile;

						// pagination
						global $wp_query;
						$pages = $wp_query->max_num_pages;
						if ($pages > 1) { ?>
							<div class="tj-pagination d-flex">
								<?php bexon_pagination('<i class="tji-arrow-left-long"></i>', '<i class="tji-arrow-right-long"></i>', '', ['class' => '']); ?>
							</div>
					<?php	};
					else :
						get_template_part('template-parts/content', 'none');
					endif; ?>

				</div>
				<!-- !post container -->
			</div>

			<?php if (is_active_sidebar('blog-sidebar')) : ?>
				<!-- sidebar -->
				<div class="col-lg-4">
					<aside class="tj-main-sidebar sticky-lg-top">
						<?php get_sidebar(); ?>
					</aside>
				</div>
				<!--!sidebar -->
			<?php endif; ?>
		</div>
	</div>
</div>

<?php
get_footer();
