<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

get_header();


$bexonBlogColumn = is_active_sidebar('blog-sidebar') ? 8 : 12;
$bexonBlogSocials = get_theme_mod('bexon_blog_socials', false);
?>

<div class="tj-post-details__area section-gap">
	<div class="container">
		<div class="row row-gap-45">
			<div class="col-lg-<?php print esc_attr($bexonBlogColumn); ?>">
				<!-- post details container -->
				<div class="tj-post-details-container post-details-wrapper">
					<?php while (have_posts()) :
						the_post();

						get_template_part('template-parts/content', get_post_format());
					?>
						<?php if (has_tag() || !empty($bexonBlogSocials)) : ?>
							<!-- post tag & share -->
							<div class="tj-tags-post <?php echo (!empty($bexonBlogSocials) ? "" : "no-social-share"); ?>">
								<!-- post tags -->
								<?php if (has_tag()) {
									echo bexon_get_tag();
								}
								// post share
								if (!empty($bexonBlogSocials)) : ?>
									<div class="post-share">
										<ul>
											<li>
												<span><?php echo esc_html__('Share:', 'bexon'); ?></span>
											</li>
											<li>
												<a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank">
													<i class="fa-brands fa-facebook-f"></i>
												</a>
											</li>
											<li>
												<a href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>" target="_blank">
													<i class="fab fa-x-twitter"></i>
												</a>
											</li>
											<li>
												<a href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php the_permalink() ?>&amp;summary=&amp;source=<?php bloginfo('name'); ?>" target="_blank">
													<i class="fa-brands fa-linkedin-in"></i>
												</a>
											</li>
											<li>
												<a target="blank" href="https://pinterest.com/pin/create/button/?url=<?php the_permalink() ?>&media=<?php the_post_thumbnail_url('full'); ?>">
													<i class="fa-brands fa-pinterest-p"></i>
												</a>
											</li>
										</ul>
									</div>
								<?php endif; ?>
							</div>
						<?php endif; ?>

						<!-- post pagination -->
						<?php if (get_previous_post_link() || get_next_post_link()) :
							$prevPost = get_adjacent_post(false, '', true);
							$nextPost = get_adjacent_post(false, '', false);
						?>
							<div class="tj-post-navigation">
								<!-- previous post -->
								<?php if (is_a($prevPost, 'WP_Post')) :
									$prevLink = get_permalink($prevPost->ID);
								?>
									<div class="previous">
										<div class="tj-post-nav prev_post">
											<a href="<?php echo esc_url($prevLink); ?>"><span><i class="tji-arrow-left"></i></span><?php echo esc_html__('Previous', 'bexon'); ?></a>
										</div>
									</div>
								<?php endif; ?>

								<div class="tj-post-nav-divider">
									<i class="tji-window"></i>
								</div>

								<!-- next post -->
								<?php
								if (is_a($nextPost, 'WP_Post')) :
									$nextLink = get_permalink($nextPost->ID);
								?>
									<div class="next">
										<div class="tj-post-nav next_post">
											<a href="<?php echo esc_url($nextLink); ?>"><?php echo esc_html__('Next', 'bexon'); ?><span><i class="tji-arrow-right"></i></span></a>
										</div>
									</div>
								<?php endif; ?>
							</div>

						<?php endif; ?>


					<?php
						// If comments are open or we have at least one comment, load up the comment template.
						if (comments_open() || get_comments_number()) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div>
				<!-- !post details container -->
			</div>

			<?php if (is_active_sidebar('blog-sidebar')) : ?>
				<!-- sidebar -->
				<div class="col-lg-4">
					<aside class="tj-main-sidebar sticky-lg-top">
						<?php get_sidebar(); ?>
					</aside>
				</div> <!-- !sidebar -->
			<?php endif; ?>

		</div>
	</div>
</div>

<?php
get_footer();
