<?php

/**
 * Template part for displaying post btn
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

$showBlogBtn = get_theme_mod('show_blog_btn', true);
$blogBtnText = get_theme_mod('blog_btn_text', esc_html__('Read More', 'bexon'));

?>

<?php if (!empty($showBlogBtn)) : ?>
  <div class="blog-btn">
    <a class="text-btn" href="<?php the_permalink(); ?>">
      <span class="btn-text"><span><?php echo esc_html($blogBtnText); ?></span></span>
      <span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
    </a>
  </div>
<?php endif; ?>