<?php

/**
 * Template part for displaying audio posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

// get audio url
$bexonAudioLink = function_exists('get_field') ? get_field('post_audio_link') : NULL;
$bexonBlogDate = get_theme_mod('bexon_blog_date', false);

if (is_single()) : ?>

  <!-- single post -->
  <article id="post-<?php the_ID(); ?>" <?php post_class("tj-single-post format-audio"); ?>>
    <?php if (!empty($bexonAudioLink)) : ?>
      <!-- post thumbnail -->
      <div class="blog-thumb">
        <?php echo wp_oembed_get($bexonAudioLink); ?>
      </div>
    <?php endif; ?>
    <div class="blog-content">
      <!-- entry title -->
      <?php the_title('<h2 class="entry-title title">', '</h2>'); ?>
      <!-- entry-meta -->
      <?php get_template_part('template-parts/blog/post-meta-single'); ?>
      <!-- entry content -->
      <div class="tj-entry-content blog-text">
        <?php the_content(); ?>
        <?php
        wp_link_pages([
          'before'      => '<div class="tj-page-links"> <span class="tj-page-links-title">' . esc_html__('Pages:', 'bexon') . '</span>',
          'after'       => '</div>',
          'link_before' => '<span>',
          'link_after'  => '</span>',
          'pagelink'    => '<span class="screen-reader-text">' . esc_html__('Page', 'bexon') . ' </span>%',
          'separator'   => '<span class="screen-reader-text"> </span>',
        ]);
        ?>
      </div>
    </div>
  </article>
  <!-- !single post -->

<?php else : ?>

  <!-- post-<?php the_ID(); ?> -->
  <article id="post-<?php the_ID(); ?>" <?php post_class("blog-item format-audio"); ?>>
    <?php if (!empty($bexonAudioLink)) : ?>
      <!-- post thumbnail -->
      <div class="blog-thumb">
        <?php echo wp_oembed_get($bexonAudioLink); ?>
      </div>
    <?php endif; ?>
    <div class="blog-content">
      <!-- entry-meta -->
      <?php get_template_part('template-parts/blog/post-meta'); ?>
      <!-- entry title -->
      <?php the_title('<h3 class="entry-title title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
      <?php if (get_the_excerpt()): ?>
        <!-- excerpt -->
        <div class="excerpt desc"><?php echo wp_trim_words(get_the_excerpt(), '40', '...'); ?></div>
      <?php endif; ?>
      <!-- post btn -->
      <?php get_template_part('template-parts/blog/post-btn'); ?>
    </div>
  </article><!-- !post-<?php the_ID(); ?> -->

<?php endif; ?>