<?php

/**
 * Single variation cart button
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.3.0
 */

defined('ABSPATH') || exit;

global $product;
?>
<div class="woocommerce-variation-add-to-cart variations_button product__details-action">
	<?php do_action('woocommerce_before_add_to_cart_button'); ?>

	<div class="tj-product-details-action-wrapper">
		<div class="tj-product-details-action-item-wrapper d-flex align-items-center">
			<div class="tj-product-details-quantity">
				<div class="tj-product-quantity">
					<?php
					do_action('woocommerce_before_add_to_cart_quantity');

					woocommerce_quantity_input(
						array(
							'min_value'   => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product),
							'max_value'   => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
							'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
						)
					);

					do_action('woocommerce_after_add_to_cart_quantity');
					?>
				</div>
			</div>

			<div class="tj-product-details-add-to-cart">
				<button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="single_add_to_cart_button tj-cart-btn <?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>">
					<span class="btn-icon"><i class="fal fa-shopping-cart"></i><i class="fal fa-shopping-cart"></i></span>
					<span class="btn-text"><span><?php echo esc_html__('Add to cart', 'bexon') ?></span></span>
				</button>
			</div>
			<?php if (function_exists('woosw_init')) : ?>
				<div class="tj-product-details-wishlist">
					<?php echo do_shortcode('[woosw]'); ?>
				</div>
			<?php endif; ?>

		</div>
	</div>

	<?php do_action('woocommerce_after_add_to_cart_button'); ?>

	<input type="hidden" name="add-to-cart" value="<?php echo absint($product->get_id()); ?>" />
	<input type="hidden" name="product_id" value="<?php echo absint($product->get_id()); ?>" />
	<input type="hidden" name="variation_id" class="variation_id" value="0" />
</div>