<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate Verification | NEFT Energies</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .search-container {
            max-width: 600px;
            margin: 40px auto;
        }
        .search-box {
            border-radius: 10px;
            padding: 10px;
            font-size: 18px;
        }
        .search-btn {
            border-radius: 10px;
            font-size: 18px;
        }
        .success-message {
            background-color: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            display: flex;
            align-items: center;
        }
        .table-custom th, .table-custom td {
            vertical-align: middle;
            text-align: center;
        }
        .info-box {
            background: #fff3cd;
            border-left: 5px solid #ffc107;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
        }
        .expired-message {
            background-color: #f8d7da;
            color: #721c24;
            padding: 10px;
            border-radius: 5px;
            margin-top: 15px;
            text-align: center;
        }
        .valid-message {
            background-color: #d4edda;
            color: #155724;
            padding: 10px;
            border-radius: 5px;
            margin-top: 15px;
            text-align: center;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="text-center">
        <img src="logo.png" alt="NEFT Energies Logo" width="150">
        <h2 class="mt-3">Certificate Verification</h2>
    </div>

    <div class="search-container">
        <form method="POST">
            <div class="input-group">
                <input type="text" class="form-control search-box" name="query" placeholder="Enter NEFT Certificate No." required>
                <button type="submit" class="btn btn-success search-btn">Search</button>
            </div>
        </form>
    </div>

    <?php
    // Database connection
    $connect = mysqli_connect("localhost", "neftenergies_app", "8wmW2AO@!ex5", "neftenergies_app");
    
    if (!$connect) {
        die("<div class='alert alert-danger mt-3'>Database connection failed!</div>");
    }

    if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["query"])) {
        $search = mysqli_real_escape_string($connect, $_POST["query"]);

        $query = "SELECT * FROM certifications WHERE neft_certificate_number = ?";
        $stmt = mysqli_prepare($connect, $query);
        mysqli_stmt_bind_param($stmt, "s", $search);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) > 0) {
            echo '<div class="alert alert-success mt-3"><strong>Success!</strong> Certificate verified.</div>';

            echo '<div class="table-responsive">
                    <table class="table table-striped table-bordered mt-3 table-custom">
                        <thead class="table-dark">
                            <tr>
                                <th>Certificate</th>
                                <th>Name</th>
                                <th>Course Name</th>
                                <th>Expiry Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>';

            while ($row = mysqli_fetch_array($result)) {
                $expiry_date = $row["expiration_date"];
                $expiry_date_obj = new DateTime($expiry_date);
                $current_date = new DateTime();
                $is_expired = $expiry_date_obj < $current_date;

                echo '<tr>
                        <td>' . $row["neft_certificate_number"] . '</td>
                        <td>' . $row["name"] . '</td>
                        <td>' . $row["course_name"] . '</td>
                        <td>' . $expiry_date . '</td>
                        <td>';

                if ($is_expired) {
                    echo '<span class="badge bg-danger">Expired</span>';
                } else {
                    echo '<span class="badge bg-success">Valid</span>';
                }

                echo '</td></tr>';
            }

            echo '  </tbody>
                </table>
            </div>';
        } else {
            echo '<div class="alert alert-danger mt-3"><strong>Error:</strong> Certificate not found.</div>';
        }
    }

    mysqli_close($connect);
    ?>

    <div class="info-box">
        <p><strong>Information/Instructions:</strong></p>
        <ul>
            <li>You can only search by NEFT Energies Certificate No. for example "NEFT12345" or "NEFT - 2024 - 12345"..</li>
            <li>Please type the certificate number exactly as mentioned on the card.</li>
            <li>Online records will be updated at the end of each workday.</li>
        </ul>
    </div>
</div>

</body>
</html>
