<?php
// Database configuration
$host = 'localhost';
$dbname = 'neftenergies_verification'; // your database name
$username = 'neftenergies_verification'; // your database username
$password = 'Neft0124@'; // your database password

// Establish a database connection
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    die("Could not connect to the database: " . $e->getMessage());
}

// Function to fetch certificate details
function getCertificateDetails($pdo, $cert_number) {
    $stmt = $pdo->prepare("SELECT * FROM certificates WHERE cert_number = ?");
    $stmt->execute([$cert_number]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

$record = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cert_number'])) {
    $cert_number = trim($_POST['cert_number']);
    if (!empty($cert_number)) {
        $record = getCertificateDetails($pdo, $cert_number);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Certificate</title>
</head>
<body>
    <h1>Verify Student Certificate</h1>
    <form method="post" action="">
        <label for="cert_number">Certificate ID:</label>
        <input type="text" id="cert_number" name="cert_number" required>
        <button type="submit">Verify</button>
    </form>
    <?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
        <?php if ($record): ?>
            <h2>Certificate Details:</h2>
            <p><strong>Certificate ID:</strong> <?= htmlspecialchars($record['cert_number']) ?></p>
            <p><strong>Course:</strong> <?= htmlspecialchars($record['course_name']) ?></p>

        <?php else: ?>
            <p style="color: 
red;">Invalid Certificate ID. No record found.</p>
        <?php endif; ?>
    <?php endif; ?>
</body>
</html>